# While 루프
`while` 루프와 `True`, `False` 값을 해금했어요. `while` 루프는 조건이 `True`인 동안 루프 본문을 계속 실행해요.

`while condition:
	#루프 본문`

무한 루프를 만드는 것에 대해 걱정하지 마세요. 실행 지연이 프로그램이 멈추는 것을 방지할 거예요.

## 초보자를 위해
아마 이미 여러 `harvest()` 호출을 연달아 넣어 보셨을 거예요:

`harvest()
harvest()
harvest()`

이렇게 하면 한 번의 프로그램 실행으로 여러 번 수확할 수 있어요.
하지만 세 번 이상 수확하고 싶을 텐데, 같은 코드를 여러 번 쓰는 것은 좋지 않은 습관이에요.
해결책은 루프예요.
루프를 사용하면 같은 코드를 여러 번 실행할 수 있어요.

while 루프는 조건을 받는데, 이것은 `True` 또는 `False` 두 가지 상태 중 하나만 가질 수 있는 논리값이에요.
이런 값을 불리언 값이라고 해요.

그런 다음 루프는 조건이 False가 될 때까지 루프 안의 코드를 실행해요.
while 루프는 다음과 같아요:

`while condition:
	#루프 본문
	#루프 본문
	#...`
	
여기서 "condition"을 불리언 값으로, `#루프 본문`을 루프에서 하고 싶은 일로 바꿔야 해요.

사용 가능한 상수 불리언 값은 두 가지가 있어요. 상수는 프로그램 동안 절대 변하지 않는 값이에요.

항상 `True`인 상수 불리언 값을 만들려면 `True`라고 쓰면 돼요. 항상 `False`인 상수 불리언 값은 `False`라고 쓰세요.
그래서 다음과 같이 쓸 수 있어요


`while False:
	do_a_flip()`

또는

`while True:
	do_a_flip()`

첫 번째는 절대 재주를 넘지 않고, 두 번째는 영원히 재주를 넘을 거예요 (무한 루프).

보통 무한 루프를 만드는 것은 프로그램이 멈추기 때문에 좋지 않은 생각이지만, 이 게임에서는 루프의 각 반복 사이에 지연이 있어서, 실행 버튼을 다시 눌러 수동으로 멈출 때까지 드론이 계속 재주를 넘게 할 거예요.

콜론 다음 줄이 어떻게 들여쓰기 되었는지 주목하세요. 이와 같은 들여쓰기는 코드 블록을 구분하는 데 사용돼요.
들여쓰기를 추가하려면 Tab 키를, 제거하려면 Shift + Tab(또는 Backspace)을 누르세요.

루프는 콜론 뒤의 모든 들여쓰기된 문장을 반복할 거예요.
들여쓴 블록 뒤의 문장들은 루프가 끝난 후에 실행돼요.